/*
 * Decompiled with CFR 0.152.
 */
package appbot.botania;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class MECorporeaNode
extends AbstractCorporeaNode {
    private final MEStorage storage;
    private final IActionSource source;

    public MECorporeaNode(Level level, BlockPos pos, ICorporeaSpark spark, MEStorage storage, IActionSource source) {
        super(level, pos, spark);
        this.storage = storage;
        this.source = source;
    }

    @Nullable
    public static ICorporeaNode getNode(Level level, ICorporeaSpark spark) {
        IActionSource source;
        MEStorage storage;
        BlockEntity blockEntity = level.m_7702_(spark.getAttachPos());
        if (blockEntity == null) {
            return null;
        }
        IStorageMonitorableAccessor accessor = (IStorageMonitorableAccessor)blockEntity.getCapability(Capabilities.STORAGE_MONITORABLE_ACCESSOR, Direction.UP).orElse(null);
        if (accessor != null && (storage = accessor.getInventory(source = IActionSource.empty())) != null) {
            return new MECorporeaNode(level, spark.getAttachPos(), spark, storage, source);
        }
        return null;
    }

    public List<ItemStack> countItems(ICorporeaRequest request) {
        return this.work(request, false);
    }

    public List<ItemStack> extractItems(ICorporeaRequest request) {
        return this.work(request, true);
    }

    protected List<ItemStack> work(ICorporeaRequest request, boolean execute) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2LongMap.Entry entry : this.storage.getAvailableStacks()) {
            int amount = Ints.saturatedCast((long)entry.getLongValue());
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            ItemStack stack = itemKey.toStack();
            if (!request.getMatcher().test(stack)) continue;
            request.trackFound(amount);
            int remainder = Math.min(amount, request.getStillNeeded() == -1 ? amount : request.getStillNeeded());
            if (remainder <= 0) continue;
            request.trackSatisfied(remainder);
            if (execute) {
                if (!this.getSpark().isCreative()) {
                    remainder = (int)this.storage.extract((AEKey)entry.getKey(), (long)remainder, Actionable.MODULATE, this.source);
                }
                this.getSpark().onItemExtracted(stack);
                request.trackExtracted(remainder);
            }
            itemKey.addDrops((long)remainder, list, null, null);
        }
        return list;
    }
}

